'use client'
import { Modal } from "antd"
import trueGif from '../../../../public/assets/true.gif'
import Image from "next/image"
import Link from "next/link"
import { placeholderImage, t } from "@/utils"


const AdEditSuccessfulModal = ({ IsAdSuccessfulModal, OnHide }) => {
    return (
        <Modal
            centered
            open={IsAdSuccessfulModal}
            colorIconHover='transparent'
            onCancel={OnHide}
            footer={null}
            closeIcon={null}
            className='adsuccessfull_modal'
        >
            <div className="adsuccessfull">
                <Image src={trueGif} width={250} height={250} alt="True" onErrorCapture={placeholderImage} />
                <h2 className="ad_succ_head">{t('adEditedSuccess')}</h2>
                <Link href='/ads' className=    "viewAdBtn">{t('viewAd')}</Link>
                <Link href='/' className="backtoHome">{t('backToHome')}</Link>
            </div>
        </Modal>
    )
}

export default AdEditSuccessfulModal